import QtQuick 2.0
import QtQuick.Controls 1.0
import QtQuick.Controls.Styles 1.0

Item {
    property var background       : String()
    property var buyButtonPressed : String()
    property var buyButtonHovered : String()
    property var buyButtonNormal  : String()
    property var launchAppFont    : String()

    id: nag
    width: 493
    height: 282
    focus: true

    Component.onCompleted: {
        background       = String("./%1/background.png").arg(Qt.locale().name.toString())

        buyButtonPressed = String("./%1/button_buy/pressed.png").arg(Qt.locale().name.toString())
        buyButtonHovered = String("./%1/button_buy/hover.png").arg(Qt.locale().name.toString())
        buyButtonNormal  = String("./%1/button_buy/normal.png").arg(Qt.locale().name.toString())

        launchAppFont = String("Arial")
    }

    Keys.onEscapePressed: {
        nag.close();
    }

    Keys.onReturnPressed: {
        nag.buyNow();
    }

    Keys.onEnterPressed: {
        nag.buyNow();
    }

    // Background
    Image {
        source: background
    }

    // Close button
    Button {
        id: closeButton
        anchors {
            right: parent.right
            top: parent.top
            rightMargin: 4
            topMargin: 4
        }
        text: ""
        style: ButtonStyle {
            background: Image {
                source: control.pressed ? "./common/button_close/pressed.png"
                                        : control.hovered ? "./common/button_close/hover.png"
                                                          : "./common/button_close/normal.png"
            }
        }
        onClicked: close()
    }

    // Buy button
    Button {
        id: buyButton
        anchors {
            right:  parent.right
            bottom: parent.bottom
            rightMargin: 17
            bottomMargin: 18
        }
        text: ""
        style: ButtonStyle {
            background: Image {
                source: control.pressed ? buyButtonPressed
                                        : control.hovered ? buyButtonHovered : buyButtonNormal
            }
        }
        onClicked: nag.buyNow()
    }

    // Callback's
    function close() {
        callback.Reject();
    }

    function buyNow() {
        callback.BuyNow();
    }
}

